#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_PatientAssignments : BaseTest 
	{

		
		private DataTable _dtOrderedUnit;

		[SetUp]
		protected void SetUp() 
		{			
			this.BaseSetUp();

			if (this.RefreshData)
			{
				this._dtOrderedUnit = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM OrderedUnit WHERE RecordStatusCode = 'A' AND DivisionCode = '" + UnitTestConfig.TestDivisionCode + "'", true);

				this.RefreshData = false;
			}
		}

		[Test]
		public void GetPatientsAssignmentDetails_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtOrderedUnit.Rows[0][TABLES.OrderedUnit.BloodUnitGuid];

			DataTable dtTest = DAL.PatientAssignments.GetPatientsAssignmentDetails(unitGuid);

			Assert.IsTrue(dtTest.Rows.Count >= 0);
			Assert.IsTrue(dtTest.Columns.Count == 20);
		}

		[Test]
		public void GetPatientsAssignmentDetails_Fail()
		{
			DataTable dtTest = DAL.PatientAssignments.GetPatientsAssignmentDetails(System.Guid.NewGuid());

			Assert.IsTrue(dtTest.Rows.Count == 0);
		}

		[Test]
		public void GetPatientSpecimenAssignmentDetails_Pass()
		{
			System.Guid unitGuid = (System.Guid)this._dtOrderedUnit.Rows[0][TABLES.OrderedUnit.BloodUnitGuid];

			DataTable dtTest = DAL.PatientAssignments.GetPatientSpecimenAssignmentDetails(unitGuid);

			Assert.IsTrue(dtTest.Rows.Count >= 0);
			Assert.IsTrue(dtTest.Columns.Count == 2);
			Assert.IsTrue(dtTest.Columns.Contains(Common.VbecsTables.PatientSpecimen.PatientGuid));
			Assert.IsTrue(dtTest.Columns.Contains(Common.VbecsTables.PatientSpecimen.PatientSpecimenGuid));
		}

		[Test]
		public void GetPatientSpecimenAssignmentDetails_Fail()
		{
			DataTable dtTest = DAL.PatientAssignments.GetPatientSpecimenAssignmentDetails(System.Guid.NewGuid());

			Assert.IsTrue(dtTest.Rows.Count == 0);
		}

	}
}
#endif
